% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calibrate_BPP_threshold}
\alias{calibrate_BPP_threshold}
\title{Function to calculate the 'optimal' BPP threshold value}
\usage{
calibrate_BPP_threshold(
  n_c,
  n_t,
  control_model,
  effect_model,
  recruitment_model,
  IA_model,
  analysis_model,
  data_generating_model,
  n_sims = 100
)
}
\arguments{
\item{n_c}{Number of control patients}

\item{n_t}{Number of treatment patients}

\item{control_model}{A named list specifying the control arm survival distribution:
\itemize{
\item \code{dist}: Distribution type ("Exponential" or "Weibull")
\item \code{parameter_mode}: Either "Fixed" or "Distribution"
\item \code{fixed_type}: If "Fixed", specify as "Parameters" or "Landmark"
\item \code{lambda}, \code{gamma}: Scale and shape parameters
\item \code{t1}, \code{t2}: Landmark times
\item \code{surv_t1}, \code{surv_t2}: Survival probabilities at landmarks
\item \code{t1_Beta_a}, \code{t1_Beta_b}, \code{diff_Beta_a}, \code{diff_Beta_b}: Beta prior parameters
}}

\item{effect_model}{A named list specifying beliefs about the treatment effect:
\itemize{
\item \code{delay_SHELF}, \code{HR_SHELF}: SHELF objects encoding beliefs
\item \code{delay_dist}, \code{HR_dist}: Distribution types ("hist" by default)
\item \code{P_S}: Probability that survival curves separate
\item \code{P_DTE}: Probability of delayed separation, conditional on separation
}}

\item{recruitment_model}{A named list specifying the recruitment process:
\itemize{
\item \code{method}: "power" or "PWC"
\item \code{period}, \code{power}: Parameters for power model
\item \code{rate}, \code{duration}: Comma-separated strings for PWC model
}}

\item{IA_model}{A named list specifying the censoring mechanism for the future data:
\itemize{
\item \code{events}: Number of events which is 100\% information fraction
\item \code{IF}: The information fraction at which to censor and calculate BPP
}}

\item{analysis_model}{A named list specifying the final analysis and decision rule:
\itemize{
\item \code{method}: e.g. \code{"LRT"}, \code{"WLRT"}, or \code{"MW"}.
\item \code{alpha}: one-sided type I error level.
\item \code{alternative_hypothesis}: direction of the alternative (e.g. \code{"one.sided"}).
\item \code{rho}, \code{gamma}, \code{t_star}, \code{s_star}: additional parameters for WLRT or MW (if applicable).
}}

\item{data_generating_model}{A named list specifying the parameters for the data-generating mechanism
\itemize{
\item \code{lambda_c}: hazard rate for the control group
\item \code{delay_time}: time at which the treatment starts to take effect
\item \code{post_delay_HR}: hazard ratio, after \code{delay_time}
}}

\item{n_sims}{Number of data sets to simulate (default is 100).}
}
\value{
A vector of length \code{n_sims} corresponding to the value of BPP for each simulated trial
}
\description{
Function to calculate the 'optimal' BPP threshold value
}
\examples{
set.seed(123)
control_model = list(dist = "Exponential",
                     parameter_mode = "Distribution",
                     t1 = 12,
                     t1_Beta_a = 20,
                     t1_Beta_b = 32)

effect_model = list(delay_SHELF = SHELF::fitdist(c(5.5, 6, 6.5),
                    probs = c(0.25, 0.5, 0.75), lower = 0, upper = 12),
                    delay_dist = "gamma",
                    HR_SHELF = SHELF::fitdist(c(0.5, 0.6, 0.7),
                    probs = c(0.25, 0.5, 0.75), lower = 0, upper = 1),
                    HR_dist = "gamma",
                    P_S = 1,
                    P_DTE = 0)

recruitment_model <- list(method = "power", period = 12, power = 1)

IA_model = list(events = 20, IF = 0.5)

analysis_model = list(method = "LRT",
                      alpha = 0.025,
                      alternative_hypothesis = "one.sided")


data_generating_model = list(lambda_c = log(2)/12,
                             delay_time = 3,
                             post_delay_HR = 0.75)


threshold <- calibrate_BPP_threshold(n_c = 15, n_t = 15,
                     control_model = control_model,
                     effect_model = effect_model,
                     recruitment_model = recruitment_model,
                     IA_model = IA_model,
                     analysis_model = analysis_model,
                     data_generating_model = data_generating_model,
                     n_sims = 2)

}
