% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_2NMAE.R
\name{compute.nmae}
\alias{compute.nmae}
\title{Normalized Mean Absolute Error (NMAE)}
\usage{
compute.nmae(Y, X)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}
}
\description{
Estimates the Normalized Mean Absolute Error of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of NMAE of two vectors corresponding to univariate signals.
A lower NMAE (\eqn{NMAE \in [0, \inf]}) value indicates a better performance method for the imputation task.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
compute.nmae(Y,X)

# If true values is a constant vector, NMAE = Inf.
# A warning is displayed and MAE is estimated instead of NMAE,
# unless true and imputed values are equal. In this case,
# by definition, NMAE = 0.
X <- rep(0, 10)
Y <- runif(10)
compute.nmae(Y,X) # MAE computed
Y <- X
compute.nmae(Y,X) # By definition, NMAE = 0
}
\author{
Camille Dezecache, Hong T. T. Phan, Emilie Poisson-Caillault
}
