/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.dataengine.utilities;

import com.amazon.dsi.utilities.CalendarSetter;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampTz
extends Timestamp {
    private static final long serialVersionUID = -5521593264075626189L;
    private Calendar m_timezoneCal;

    public TimestampTz(Timestamp timestamp, Calendar calendar) {
        super(timestamp.getTime());
        this.setNanos(timestamp.getNanos());
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    public TimestampTz(long l, Calendar calendar) {
        super(l);
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    public TimestampTz(long l, int n, Calendar calendar) {
        super(l);
        this.setNanos(n);
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof TimestampTz) {
            TimestampTz timestampTz = (TimestampTz)object;
            return this.m_timezoneCal.getTimeZone().getOffset(this.getTime()) == timestampTz.getTimezoneCalendar().getTimeZone().getOffset(timestampTz.getTime());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 7 * this.m_timezoneCal.getTimeZone().getOffset(this.getTime());
    }

    public synchronized Timestamp getAdjustedTimestamp() {
        return CalendarSetter.getTimestamp(this, Calendar.getInstance(), this.m_timezoneCal);
    }

    public Calendar getTimezoneCalendar() {
        return this.m_timezoneCal;
    }

    @Override
    public Object clone() {
        TimestampTz timestampTz = (TimestampTz)super.clone();
        if (this.m_timezoneCal != null) {
            timestampTz.m_timezoneCal = (Calendar)this.m_timezoneCal.clone();
        }
        return timestampTz;
    }
}

