/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class CancelRequest
extends AbstractOutboundMessage
implements PGConstants {
    private static int CANCEL_CODE = 80877102;
    private final KeyData m_key;

    public CancelRequest(KeyData keyData, IPGLogger iPGLogger) {
        this.m_key = keyData;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put(byArray);
        byteBuffer.putInt(CANCEL_CODE);
        byteBuffer.put(this.m_key.getProcessID());
        byteBuffer.put(this.m_key.getSecretKey());
    }

    @Override
    public int getSize() {
        return 16;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "=>FE CancelRequest";
        iPGLogger.logDebugExternal(string);
    }
}

