/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class PingCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private static final String KEY_PARTNER_SPID = "partner_spid";
    protected String m_partnerSpId;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_PARTNER_SPID.equalsIgnoreCase(string)) {
            this.m_partnerSpId = string2;
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        this.m_partnerSpId = StringUtils.isNullOrEmpty((String)this.m_partnerSpId) ? "urn%3Aamazon%3Awebservices" : URLEncoder.encode(this.m_partnerSpId, "UTF-8");
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/idp/startSSO.ping?PartnerSpId=" + this.m_partnerSpId;
        CloseableHttpClient closeableHttpClient = null;
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(5);
        try {
            Object object;
            String string2;
            String string32;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            String string4 = EntityUtils.toString((HttpEntity)httpEntity);
            for (String string32 : this.getInputTagsfromHTML(string4)) {
                string2 = this.getValueByKey(string32, "name");
                object = this.getValueByKey(string32, "value");
                if (string2.contains("user") || string2.contains("email")) {
                    arrayList.add(new BasicNameValuePair(string2, this.m_userName));
                    continue;
                }
                if (string2.contains("pass")) {
                    arrayList.add(new BasicNameValuePair(string2, this.m_password));
                    continue;
                }
                if (StringUtils.isNullOrEmpty((String)string2)) continue;
                arrayList.add(new BasicNameValuePair(string2, (String)object));
            }
            String string5 = this.getFormAction(string4);
            if (!StringUtils.isNullOrEmpty((String)string5) && string5.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string5;
            }
            string32 = new HttpPost(string);
            string32.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)string32);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            object = SAML_PATTERN.matcher(string2);
            if (!((Matcher)object).find()) {
                throw new IOException("Failed to retrieve SAMLAssertion.");
            }
            String string6 = ((Matcher)object).group(1);
            return string6;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", (Throwable)generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly((Closeable)closeableHttpClient, null);
        }
    }
}

