/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedUpdatableResultSet;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class UpdatableResultSet
extends GeneratedUpdatableResultSet {
    static final int BEGIN_COLUMN_INDEX = 0;
    private GeneratedUpdatableResultSet.NullStatus wasNull;
    private OracleStatement scrollStmt = null;
    private ResultSetMetaData rsetMetaData = null;
    private int columnCount = 0;
    private OraclePreparedStatement deleteStmt = null;
    private OraclePreparedStatement insertStmt;
    private List<String> lastUpdateColumns = null;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged = null;
    private boolean isUpdating = false;
    private boolean isInserting = false;
    private GeneratedUpdatableResultSet.Updater[] updateBuffer = null;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;

    UpdatableResultSet(OracleStatement oracleStatement, OracleResultSet oracleResultSet) throws SQLException {
        super(oracleStatement, oracleResultSet);
        this.scrollStmt = oracleStatement;
        this.wasNull = GeneratedUpdatableResultSet.NullStatus.VALUE_UNKNOWN;
        this.getInternalMetadata();
    }

    @Override
    void ensureOpen() throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
        }
        if (this.resultSet == null || this.scrollStmt == null || this.scrollStmt.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            if (this.deleteStmt != null) {
                this.deleteStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            this.connection = LogicalConnection.closedConnection;
            this.resultSet = null;
            this.scrollStmt = null;
            this.rsetMetaData = null;
            this.scrollStmt = null;
            this.deleteStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.indexColsChanged = null;
            this.updateBuffer = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            switch (this.wasNull) {
                case VALUE_UNKNOWN: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
                }
                case VALUE_IN_RSET: {
                    return this.resultSet.wasNull();
                }
                case VALUE_NULL: {
                    return true;
                }
                case VALUE_NOT_NULL: {
                    return false;
                }
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.scrollStmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            SQLWarning sQLWarning = this.resultSet.getWarnings();
            if (this.sqlWarning == null) {
                return sQLWarning;
            }
            SQLWarning sQLWarning2 = this.sqlWarning;
            while (sQLWarning2.getNextWarning() != null) {
                sQLWarning2 = sQLWarning2.getNextWarning();
            }
            sQLWarning2.setNextWarning(sQLWarning);
            return this.sqlWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.sqlWarning = null;
            this.resultSet.clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.getAuthorizationIndicator(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                this.isRowDeleted = false;
                return this.resultSet.isValidRow();
            }
            return this.resultSet.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                return this.resultSet.isFirst();
            }
            return this.resultSet.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.isFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.isLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.beforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.afterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            return this.resultSet.getRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.absolute(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                --n2;
                this.isRowDeleted = false;
            }
            return this.resultSet.relative(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            return this.resultSet.previous();
        }
    }

    void addToTempLobsToFree(Clob clob) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(clob);
    }

    void addToTempLobsToFree(Blob blob) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(blob);
    }

    void cleanTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
    }

    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.resultSet.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.findColumn(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchDirection(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchDirection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchSize();
        }
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return this.scrollStmt.realRsetType.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1008;
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureOpen();
        return this.isRowDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (!this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83).fillInStackTrace();
            }
            this.prepareInsertRowStatement();
            this.prepareInsertRowBinds();
            RowId rowId = this.executeInsertRow();
            this.resultSet.insertRow(rowId);
            this.cancelRowChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            int n2 = this.getNumColumnsChanged();
            if (n2 > 0) {
                this.prepareUpdateRowStatement(n2);
                this.prepareUpdateRowBinds(n2);
                this.executeUpdateRow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            this.prepareDeleteRowStatement();
            this.prepareDeleteRowBinds();
            this.executeDeleteRow();
            this.isRowDeleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            this.resultSet.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isUpdating) {
                this.isUpdating = false;
                this.clearUpdateBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                return;
            }
            this.isRowDeleted = false;
            this.isInserting = true;
            if (this.updateBuffer == null) {
                this.updateBuffer = new GeneratedUpdatableResultSet.Updater[this.getColumnCount()];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.cancelRowChanges();
        }
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            String string = this.getInternalMetadata().getColumnClassName(n2);
            try {
                return this.getObject(n2, Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, classNotFoundException).fillInStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            assert (clazz != null) : "type: null";
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            T t2 = null;
            this.setIsNull(GeneratedUpdatableResultSet.NullStatus.VALUE_UNKNOWN);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                GeneratedUpdatableResultSet.Updater updater = this.getUpdater(n2);
                if (updater == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
                }
                t2 = JavaToJavaConverter.convert(updater.getValue(), clazz, this.connection, updater.getExtra(), null);
                this.setIsNull(updater.getValue() == null);
            } else {
                this.setIsNull(GeneratedUpdatableResultSet.NullStatus.VALUE_IN_RSET);
                t2 = this.resultSet.getObject(n2, clazz);
            }
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNull(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNull").fillInStackTrace();
            }
            final int n3 = this.getInternalMetadata().getColumnType(n2);
            if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003 || n3 == 2009) {
                final String string = this.getInternalMetadata().getColumnTypeName(n2);
                this.setUpdater(n2, new GeneratedUpdatableResultSet.Updater(null){

                    @Override
                    public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                        oraclePreparedStatement.setNull(n2, n3, string);
                    }
                });
            } else {
                this.setUpdater(n2, new GeneratedUpdatableResultSet.Updater(null){

                    @Override
                    public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                        oraclePreparedStatement.setNull(n2, n3);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            final int n4 = this.getInternalMetadata().getColumnType(n2);
            this.setUpdater(n2, new GeneratedUpdatableResultSet.Updater(object){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setObject(n2, this.value, n4, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, final SQLType sQLType) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            this.setUpdater(n2, new GeneratedUpdatableResultSet.Updater(object){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setObject(n2, this.value, sQLType);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object, final SQLType sQLType, final int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            this.setUpdater(n2, new GeneratedUpdatableResultSet.Updater(object){

                @Override
                public void set(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
                    oraclePreparedStatement.setObject(n2, this.value, sQLType, n3);
                }

                @Override
                public Object getExtra() {
                    return n3;
                }
            });
        }
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet.getColumnCount();
        }
        return this.columnCount;
    }

    OracleResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return (OracleResultSetMetaData)this.rsetMetaData;
    }

    private void cancelRowChanges() throws SQLException {
        if (this.isInserting) {
            this.cancelRowInserts();
        }
        if (this.isUpdating) {
            this.cancelRowUpdates();
        }
    }

    @Override
    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearUpdateBuffer();
        }
    }

    @Override
    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void clearUpdateBuffer() {
        if (this.updateBuffer != null) {
            for (int i2 = 0; i2 < this.updateBuffer.length; ++i2) {
                this.updateBuffer[i2] = null;
            }
        }
        this.cleanTempLobs();
    }

    @Override
    protected void setUpdater(int n2, GeneratedUpdatableResultSet.Updater updater) throws SQLException {
        assert (n2 > 0 && n2 <= this.getColumnCount()) : "columnIndex: " + n2 + " columnCount: " + this.getColumnCount();
        assert (updater != null) : "setter is null";
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.isUpdating = true;
        }
        if (this.updateBuffer == null) {
            this.updateBuffer = new GeneratedUpdatableResultSet.Updater[this.getColumnCount()];
        }
        this.updateBuffer[n2 - 1] = updater;
    }

    @Override
    protected GeneratedUpdatableResultSet.Updater getUpdater(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getUpdater").fillInStackTrace();
        }
        if (this.updateBuffer != null) {
            return this.updateBuffer[n2 - 1];
        }
        return null;
    }

    @Override
    protected boolean isRowBufferUpdatedAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "isRowBufferUpdatedAt").fillInStackTrace();
        }
        if (this.updateBuffer == null) {
            return false;
        }
        return this.updateBuffer[n2 - 1] != null;
    }

    private void prepareInsertRowStatement() throws SQLException {
        OracleResultSetMetaData oracleResultSetMetaData = this.getInternalMetadata();
        ArrayList<String> arrayList = new ArrayList<String>(this.updateBuffer.length);
        boolean bl = false;
        for (int i2 = 1; i2 <= this.updateBuffer.length; ++i2) {
            if (!this.isRowBufferUpdatedAt(i2)) continue;
            arrayList.add(oracleResultSetMetaData.getColumnName(i2));
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 86).fillInStackTrace();
        }
        if (this.insertStmt == null || !arrayList.equals(this.lastUpdateColumns)) {
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            this.lastUpdateColumns = arrayList;
            String string = this.scrollStmt.sqlObject.getInsertSqlForUpdatableResultSet(arrayList);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string, 1);
            this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.insertStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.insertStmt, n2);
        OracleResultSetMetaData oracleResultSetMetaData = this.getInternalMetadata();
        int n3 = n2;
        for (int i2 = 1; i2 <= this.getColumnCount(); ++i2) {
            GeneratedUpdatableResultSet.Updater updater = this.getUpdater(i2);
            if (updater == null) continue;
            if (oracleResultSetMetaData.isNCHAR(i2)) {
                this.insertStmt.setFormOfUse(n3, (short)2);
            }
            updater.set(this.insertStmt, n3++);
        }
    }

    private RowId executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
        try (ResultSet resultSet = this.insertStmt.getGeneratedKeys();){
            resultSet.next();
            RowId rowId = resultSet.getRowId(1);
            return rowId;
        }
    }

    private int getNumColumnsChanged() throws SQLException {
        int n2 = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.updateBuffer != null) {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                if (this.updateBuffer[i2] == null) continue;
                this.indexColsChanged[n2++] = i2;
            }
        }
        return n2;
    }

    private void prepareUpdateRowStatement(int n2) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        String string = this.scrollStmt.sqlObject.getUpdateSqlForUpdatableResultSet(this, n2, (Object[])this.updateBuffer, this.indexColsChanged);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
        this.updateStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
        if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
            this.updateStmt.setEscapeProcessing(true);
        }
    }

    private void prepareUpdateRowBinds(int n2) throws SQLException {
        int n3 = 1;
        n3 = this.prepareSubqueryBinds(this.updateStmt, n3);
        OracleResultSetMetaData oracleResultSetMetaData = this.getInternalMetadata();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.indexColsChanged[i2];
            GeneratedUpdatableResultSet.Updater updater = this.getUpdater(n4 + 1);
            Object t2 = updater.getValue();
            if (t2 != null) {
                if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                    this.updateStmt.setFormOfUse(n3, (short)2);
                }
                updater.set(this.updateStmt, n3++);
                continue;
            }
            int n5 = this.getInternalMetadata().getColumnType(n4 + 1);
            if (n5 == 2006 || n5 == 2002 || n5 == 2008 || n5 == 2007 || n5 == 2003 || n5 == 2009) {
                this.updateStmt.setNull(n3++, n5, this.getInternalMetadata().getColumnTypeName(n4 + 1));
                continue;
            }
            if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                this.updateStmt.setFormOfUse(n3, (short)2);
            }
            this.updateStmt.setNull(n3++, n5);
        }
        this.prepareCompareSelfBinds(this.updateStmt, n3);
    }

    private void executeUpdateRow() throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
            }
            this.refreshRows(this.getRow() - 1, 1);
            this.cancelRowUpdates();
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        return this.resultSet.refreshRows(l2, n2);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            String string = this.scrollStmt.sqlObject.getDeleteSqlForUpdatableResultSet(this);
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.deleteStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.deleteStmt, n2);
        this.prepareCompareSelfBinds(this.deleteStmt, n2);
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
        this.removeCurrentRowFromCache();
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        this.resultSet.removeCurrentRowFromCache();
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return this.resultSet instanceof InsensitiveScrollableResultSet ? ((InsensitiveScrollableResultSet)this.resultSet).isFromResultSetCache() : false;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return this.scrollStmt.getCompileKey();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return this.scrollStmt.getRuntimeKey();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        oraclePreparedStatement.setRowId(n2, ((InsensitiveScrollableResultSet)this.resultSet).getPrependedRowId());
        return n2 + 1;
    }

    private int prepareSubqueryBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        return n2 + this.scrollStmt.copyBinds(oraclePreparedStatement, n2 - 1);
    }

    @Override
    protected void setIsNull(GeneratedUpdatableResultSet.NullStatus nullStatus) {
        this.wasNull = nullStatus;
    }

    @Override
    protected void setIsNull(boolean bl) {
        this.setIsNull(bl ? GeneratedUpdatableResultSet.NullStatus.VALUE_NULL : GeneratedUpdatableResultSet.NullStatus.VALUE_NOT_NULL);
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
        this.resultSet.doneFetchingRows(bl);
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }

    @Override
    public int getCursorId() throws SQLException {
        return this.scrollStmt.cursorId;
    }
}

