% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiD_within_cohort.R
\name{DiDge}
\alias{DiDge}
\title{Estimate DiD for a single cohort (g) and a single event time (e).}
\usage{
DiDge(
  inputdata,
  varnames,
  cohort_time,
  event_postperiod,
  base_event = -1,
  control_group = "all",
  return_data = FALSE,
  return_ATTs_only = TRUE
)
}
\arguments{
\item{inputdata}{A data.table.}

\item{varnames}{A list of the form varnames = list(id_name, time_name, outcome_name, cohort_name), where all four arguments of the list must be a character that corresponds to a variable name in inputdata.}

\item{cohort_time}{The treatment cohort of reference.}

\item{event_postperiod}{Number of time periods after the cohort time at which to estimate the DiD.}

\item{base_event}{This is the base pre-period that is normalized to zero in the DiD estimation. Default is base_event=-1.}

\item{control_group}{There are three possibilities: control_group="never-treated" uses the never-treated control group only; control_group="future-treated" uses those units that will receive treatment in the future as the control group; and control_group="all" uses both the never-treated and the future-treated in the control group. Default is control_group="all".}

\item{return_data}{If true, this returns the treated and control differenced data. Default is FALSE.}

\item{return_ATTs_only}{Return only the ATT estimates and sample sizes. Default is TRUE.}
}
\value{
A single-row data.table() containing the estimates and various statistics such as sample size. If \code{return_data=TRUE}, it instead returns a list in which the \code{data_prepost} entry is the previously-mentioned single-row data.table(), and the other argument \code{data_prepost}  contains the constructed data that should be provided to OLS.
}
\description{
Estimate DiD for a single cohort (g) and a single event time (e).
}
\examples{
# simulate some data
simdata = SimDiD(sample_size=200)$simdata

# define the variable names as a list()
varnames = list()
varnames$time_name = "year"
varnames$outcome_name = "Y"
varnames$cohort_name = "cohort"
varnames$id_name = "id"

# estimate the ATT for cohort 2007 at event time 1
DiDge(simdata, varnames, cohort_time=2007, event_postperiod=1)

# change the base period to -3
DiDge(simdata, varnames, base_event=-3, cohort_time=2007, event_postperiod=1)

# use only the never-treated control group
DiDge(simdata, varnames, control_group = "never-treated", cohort_time=2007, event_postperiod=1)

}
