% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSSMod.R
\name{confint.DiSSMod}
\alias{confint.DiSSMod}
\title{Getting Confidence Intervals for Parameters of Discrete Sample Selection Model Fits}
\usage{
\method{confint}{DiSSMod}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class "DiSSMod" made by the function \code{DiSSMod}.}

\item{parm}{not used, but it exists for compatibility reasons.}

\item{level}{a numeric value between 0 and 1 for controlling the significance level of confidence interval;
default value is 0.95.}

\item{\dots}{not used, but it exists for compatibility reasons.}
}
\value{
a list, containing \code{level} and \code{confidence intervals} for parameters, is given.
}
\description{
\code{confint} method for a class \code{"DiSSMod"}.
}
\examples{
# example continued from DiSSMod
set.seed(45)
data(DoctorRWM, package = "DiSSMod")
n0 <- 600
set.n0 <- sample(1:nrow(DoctorRWM), n0)
reduce_DoctorRWM <- DoctorRWM[set.n0,]
result0 <- DiSSMod(response = as.numeric(DOCVIS > 0) ~ AGE + INCOME_SCALE + HHKIDS + EDUC + MARRIED,
                   selection = PUBLIC ~ AGE + EDUC + FEMALE,
                   data = reduce_DoctorRWM, resp.dist="bernoulli", select.dist = "normal",
                   alpha = seq(-5.5, -0.5, length.out = 21), standard = TRUE)

confint(result0, level = 0.90)

data(CreditMDR, package = "DiSSMod")
n1 <- 600
set.n1 <- sample(1:nrow(CreditMDR), n1)
reduce_CreditMDR <- CreditMDR[set.n1,]
result1 <- DiSSMod(response = MAJORDRG ~ AGE + INCOME + EXP_INC,
                   selection = CARDHLDR ~ AGE + INCOME + OWNRENT + ADEPCNT + SELFEMPL,
                   data = reduce_CreditMDR, resp.dist="poi", select.dist = "logis",
                   alpha = seq(-0.3, 0.3,length.out = 21), standard = FALSE, verbose = 1)

confint(result1)

}
\seealso{
See also \code{\link[stats]{confint}}, \code{\link[DiSSMod]{DiSSMod}} and \code{\link[DiSSMod]{summary.DiSSMod}}.
}
