% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_fun.R
\name{match_pvals}
\alias{match_pvals}
\title{Matching Raw P-Values with Supports}
\usage{
match_pvals(test_results, pCDFlist, pCDFlist_indices = NULL)
}
\arguments{
\item{test_results}{either a numeric vector with \eqn{p}-values or an R6 object of class \code{\link[DiscreteTests]{DiscreteTestResults}} from package \link[DiscreteTests]{DiscreteTests} for which a discrete FWER procedure is to be performed.}

\item{pCDFlist}{list of the supports of the CDFs of the \eqn{p}-values; each list item must be a numeric vector, which is sorted in increasing order and whose last element equals 1.}

\item{pCDFlist_indices}{list of numeric vectors containing the test indices that indicate to which raw \eqn{p}-value(s) each support in \code{pCDFlist} belongs; if \code{NULL} (the default) the lengths of \code{test_results} and \code{pCDFlist} \strong{must} be equal.}
}
\value{
A vector where each raw p-value has been replaced by its nearest neighbour,
if necessary.
}
\description{
Constructs the observed p-values from the raw observed p-values, by rounding
them to their nearest neighbour, matching with the supports of their
respective CDFs (as in function \code{p.discrete.adjust()} of package
\code{discreteMTP}, which is no longer available on CRAN).

\strong{Note}: This is an internal function and has to be called directly via
\code{:::}, i.e. \code{DiscreteFWER:::match_pvals()}.
}
\details{
Well computed raw p-values should already belong to their respective CDF
support. So this function is called at the beginning of
\code{\link[=discrete_FWER.default]{discrete_FWER.default()}} and its wrappers, just in case raw p-values may
be biased.

For each raw p-value that needs to be rounded, a warning is issued.
}
\seealso{
\code{\link[=discrete_FWER]{discrete_FWER()}}
}
\keyword{internal}
