% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-base.R, R/method-default.R
\name{getExportedNames}
\alias{getExportedNames}
\alias{getExportedObject}
\alias{getExportedNames,ANY-method}
\alias{getExportedObject,ANY-method}
\title{Get the exported method and variable from the provider or container}
\usage{
getExportedNames(x)

getExportedObject(x, name)

\S4method{getExportedNames}{ANY}(x)

\S4method{getExportedObject}{ANY}(x, name)
}
\arguments{
\item{x}{A cloud provider or container object}

\item{name}{The name of the exported object}
}
\value{
getExportedNames: The names of the exported functions or variables
getExportedObject: The exported functions or variable
}
\description{
Get the exported method and variable from the provider or container. These
methods should be used by the developer to export their APIs to the user. The
\code{DockerCluster} object will call \code{getExportedNames} and \code{getExportedObject} and
export them to the user.
}
\details{
If the exported object is a function, the exported function will be defined in
an environment such that the \code{DockerCluster} object is assigned to the variable \code{cluster}.
In other words, the exported function can use the variable \code{cluster} without define it.
This can be useful if the developer needs to change anything in the cluster without
asking the user to provide the \code{DockerCluster} object. The best practice is to define
\code{cluster} as the function argument, the argument will be removed when the function is
exported to the user. The user would not be bothered with the redundant \code{cluster} argument.
}
