\name{SKK}
\alias{SKK}
\title{High-Dimensional Two-Sample Mean Test}
\description{
  Conducts a high-dimensional two-sample mean test using a modified Hotelling's T-squared statistic.
  This test is suitable for cases where the number of variables \( p \) is larger than the sample size \( n \).
}
\usage{
SKK(X, Y)
}
\arguments{
  \item{X}{
    Matrix representing the first sample (rows are observations, columns are variables).
  }
  \item{Y}{
    Matrix representing the second sample (rows are observations, columns are variables).
  }
}
\value{
  A list containing:
  \item{TSvalue}{The test statistic value.}
  \item{pvalue}{The p-value of the test.}
}
\details{
  This function implements a high-dimensional two-sample mean test by adjusting the Hotelling's T-squared statistic.
  It uses diagonal matrices and a correction factor to handle high-dimensional data.
}
\examples{
# Example usage:
set.seed(123)
X <- matrix(rnorm(200), nrow = 10, ncol = 20)  # 10 samples, 20 variables
Y <- matrix(rnorm(200, mean = 0.5), nrow = 10, ncol = 20)  # Different mean
result <- SKK(X, Y)
print(result)
# Output:
# TSvalue: The test statistic value
# pvalue: The p-value indicating the significance of the test
}
