% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GaussianCopulaVaR.R
\name{GaussianCopulaVaR}
\alias{GaussianCopulaVaR}
\title{Bivariate Gaussian Copule VaR}
\usage{
GaussianCopulaVaR(mu1, mu2, sigma1, sigma2, rho, number.steps.in.copula, cl)
}
\arguments{
\item{mu1}{Mean of Profit/Loss on first position}

\item{mu2}{Mean of Profit/Loss on second position}

\item{sigma1}{Standard Deviation of Profit/Loss on first position}

\item{sigma2}{Standard Deviation of Profit/Loss on second position}

\item{rho}{Correlation between Profit/Loss on two positions}

\item{number.steps.in.copula}{Number of steps used in the copula approximation
( approximation being needed because Gaussian copula lacks a closed form solution)}

\item{cl}{VaR confidece level}
}
\value{
Copula based VaR
}
\description{
Derives VaR using bivariate Gaussian copula with specified inputs
for normal marginals.
}
\examples{
# VaR using bivariate Gaussian for X and Y with given parameters:
   GaussianCopulaVaR(2.3, 4.1, 1.2, 1.5, .6, 10, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Dowd, K. and Fackler, P. Estimating VaR with copulas. Financial Engineering
News, 2004.
}

