% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment}
\alias{segment}
\title{Segment}
\usage{
segment(hasUtteranceBE, hasSegments)
}
\arguments{
\item{hasUtteranceBE}{Table with utterances}

\item{hasSegments}{Table with segment info}
}
\value{
The function returns a \code{data.table} that has both the play
segmentation and the token data in it.
}
\description{
This function takes two tables and combines them. The first table is of the 
class QDHasUtteranceBE and contains text spans that are designated with 
begin and end character positions.
The second table of class QDHasSegments contains information about acts and scenes 
in the play. This function is used internally in many other functions, but is exported
because it might become useful.
}
\examples{
data(rksp.0)
segmentedText <- segment(rksp.0$text, rksp.0$segments)
}
