% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci95.R
\name{ci95}
\alias{ci95}
\title{Format Confidence Intervals}
\usage{
ci95(sumtable, my.digit = 1, table.aspercent = FALSE, print.aspercent = TRUE)
}
\arguments{
\item{sumtable}{A numeric vector of length 3 containing the estimate and its lower and upper confidence limits.}

\item{my.digit}{Integer; the number of decimal places to use (default is 1).}

\item{table.aspercent}{Logical; if TRUE, treats `sumtable` values as percentages (default is FALSE).}

\item{print.aspercent}{Logical; if TRUE, prints output as percentages (default is TRUE).}
}
\value{
A character string representing the formatted confidence interval.
The returned string is in the format of "estimate (lower limit-upper limit)".
For example, a return value of "50.0 (45.0-55.0)" indicates an estimate of 50.0
with a 95% confidence interval ranging from 45.0 to 55.0. If `table.aspercent`
and `print.aspercent` are both set to TRUE, the estimate and confidence limits
are expressed as percentages, facilitating easy interpretation of the interval
as a percentage range.
}
\description{
This function formats confidence intervals with specified precision.
}
\examples{
ci95(c(50, 45, 55))
ci95(c(0.5, 0.45, 0.55), my.digit = 2, table.aspercent = TRUE, print.aspercent = TRUE)

}
