% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_audit_csv_report.R
\name{get_audit_csv_report}
\alias{get_audit_csv_report}
\title{Get audit csv report}
\usage{
get_audit_csv_report(query, env = "production")
}
\arguments{
\item{query}{(character) Query (see details below)}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Zero or more audit records matching
the query parameters as specified in the request (see details below) and
streams back a comma separated values result set.
}
\description{
Get audit csv report
}
\details{
Query parameters are specified as key=value pairs, multiple pairs
must be delimited with ampersands (&), and only a single value should be
specified for a particular key. The following query parameter keys are
allowed:

\itemize{
  \item category - Can be: debug, info, error, warn
  \item service - Any of the EDI data repository services
  \item serviceMethod - Any of the EDI data repository service Resource
  class JAX-RS methods
  \item user - Any user
  \item group - Any group
  \item authSystem - A valid auth system identifier
  \item status - A valid HTTP Response Code
  \item resourceId - An EDI data repository resource identifier, e.g.
  https://pasta.lternet.edu/package/eml/knb-lter-and/2719/6, or a thereof
  (see details below)
  \item fromTime - An ISO8601 timestamp
  \item toTime - An ISO8601 timestamp
  \item limit - A positive whole number
}

The query parameters fromTime and optionally toTime should be used to
indicate a time span. When toTime is absent, the report will consist of all
matching records up to the current time. Either of these parameters may only
be used once. The query parameter limit sets an upper limit on the number of
audit records returned. For example, "limit=1000". The query parameter
resourceId will match any audit log entry whose resourceId value contains
the specified string value. Thus, a query parameter of
"resourceId=knb-lter-and" will match any audit log entry whose resourceId
value contains the substring "knb-lter-and", while a query parameter of
"resourceId=knb-lter-and/2719/6" will match any audit log entry whose
resourceId value contains the substring "knb-lter-and/2719/6".
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Get audit report for data reads between 2021-12-01 and 2021-12-02
query <- "serviceMethod=readDataEntity&fromTime=2021-12-01&toTime=2021-12-02"
auditReport <- get_audit_csv_report(query)

logout()
}

}
\seealso{
Other Audit Manager Services: 
\code{\link{get_audit_count}()},
\code{\link{get_audit_record}()},
\code{\link{get_audit_report}()},
\code{\link{get_docid_reads}()},
\code{\link{get_packageid_reads}()},
\code{\link{get_recent_uploads}()}
}
\concept{Audit Manager Services}
