% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.feature.FF.R
\name{extractor.feature.FF}
\alias{extractor.feature.FF}
\title{Extracting features According to Goretzko & Buhner (2020)}
\usage{
extractor.feature.FF(
  response,
  cor.type = "pearson",
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses of \code{N} individuals
to \code{I} items.}

\item{cor.type}{A character string indicating which correlation coefficient (or covariance) is
to be computed. One of \code{"pearson"} (default), \code{"kendall"}, or
\code{"spearman"}. @seealso \code{\link[stats]{cor}}.}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"}, \code{"na.or.complete"},
or \code{"pairwise.complete.obs"} (default). @seealso \code{\link[stats]{cor}}.}
}
\value{
A matrix (1×181) containing all the 181 features (Goretzko & Buhner, 2020).
}
\description{
This function will extract 181 features from the data according to the method by Goretzko & Buhner (2020).
}
\details{
The code for the \code{extractor.feature.FF} function is implemented based on the publicly available code by Goretzko & Buhner (2020) (https://osf.io/mvrau/).
The extracted features are completely consistent with the 181 features described in the original text by Goretzko & Buhner (2020).
These features include:

\itemize{
  \item \code{1.} - Number of examinees
  \item \code{2.} - Number of items
  \item \code{3.} - Number of eigenvalues greater than 1
  \item \code{4.} - Proportion of variance explained by the 1st eigenvalue
  \item \code{5.} - Proportion of variance explained by the 2nd eigenvalue
  \item \code{6.} - Proportion of variance explained by the 3rd eigenvalue
  \item \code{7.} - Number of eigenvalues greater than 0.7
  \item \code{8.} - Standard deviation of the eigenvalues
  \item \code{9.} - Number of eigenvalues accounting for 50% cumulative variance
  \item \code{10.} - Number of eigenvalues accounting for 75% cumulative variance
  \item \code{11.} - L1-norm of the correlation matrix
  \item \code{12.} - Frobenius-norm of the correlation matrix
  \item \code{13.} - Maximum-norm of the correlation matrix
  \item \code{14.} - Average of the off-diagonal correlations
  \item \code{15.} - Spectral-norm of the correlation matrix
  \item \code{16.} - Number of correlations smaller or equal to 0.1
  \item \code{17.} - Average of the initial communality estimates
  \item \code{18.} - Determinant of the correlation matrix
  \item \code{19.} - Measure of sampling adequacy (MSA after Kaiser, 1970)
  \item \code{20.} - Gini coefficient (Gini, 1921) of the correlation matrix
  \item \code{21.} - Kolm measure of inequality (Kolm, 1999) of the correlation matrix
  \item \code{22-101.} - Eigenvalues from Principal Component Analysis (PCA), padded with -1000 if insufficient
  \item \code{102-181.} - Eigenvalues from Factor Analysis (FA), fixed at 1 factor, padded with -1000 if insufficient
}
}
\references{
Goretzko, D., & Buhner, M. (2020). One model to rule them all? Using machine learning algorithms to determine the number of factors in exploratory factor analysis. Psychol Methods, 25(6), 776-786. https://doi.org/10.1037/met0000262.
}
