% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MM_est.R
\name{MM_est}
\alias{MM_est}
\title{Function for estimating the Michaelis-Menten constant}
\usage{
MM_est(
  method,
  timespan,
  products,
  enz,
  subs,
  catal,
  K_M_init,
  std,
  tun,
  nrepeat,
  jump,
  burn,
  K_M_m,
  K_M_v,
  volume,
  t_unit,
  c_unit
)
}
\arguments{
\item{method}{This determines which model, the sQSSA or tQSSA model, is used for the estimation. Specifically, the input for method is TRUE (FALSE); then the tQSSA (sQSSA) model is used.}

\item{timespan}{time points when the concentrations of products were measured.}

\item{products}{measured concentrations of products}

\item{enz}{initial enzyme concentrations}

\item{subs}{initial substrate concentrations}

\item{catal}{true value of the catalytic constant.}

\item{K_M_init}{initial value of K_M constant for the Metropolis-Hastings algorithm. If the input is FALSE then it is determined by max(subs).}

\item{std}{standard deviation of proposal distribution. If the input is FALSE then it is determined by using the hessian of log posterior distribution.}

\item{tun}{tuning constant for the Metropolis-Hastings algorithm when std is FALSE (i.e., hessian of the log posterior distribution is used).}

\item{nrepeat}{number of effective iteration, i.e., posterior samples.}

\item{jump}{length of distance between sampling, i.e., thinning rate.}

\item{burn}{length of burn-in period.}

\item{K_M_m}{prior mean of gamma prior for the Michaelis-Menten constant K_M. If the input is FALSE then it is determined by max(subs).}

\item{K_M_v}{prior variance of gamma prior for the Michaelis-Menten constant K_M. If the input is FALSE then it is determined by max(subs)^2*1000.}

\item{volume}{the volume of a system. It is used to scale the product concentration. FALSE input provides automatic scaling.}

\item{t_unit}{the unit of time points. It can be an arbitrary string.}

\item{c_unit}{the unit of concentrations. It can be an arbitrary string.}
}
\value{
A vector containing posterior samples of the estimated parameter: the Michaelis-Menten constant.
}
\description{
The function estimates the Michaelis-Menten constant using progress-curve data,
enzyme concentrations, substrate concentrations, and the catalytic constant.
}
\details{
The function MM_est generates a set of Markov Chain Monte Carlo
simulation samples from posterior distribution of the Michaelis-Menten constant of enzyme kinetics model.
Because the function estimates only the Michaelis-Menten constant the true value of the catalytic constant should be given.
Authors' recommendation: "Do not use this function directly. Do use the function main_est()
to estimate the parameter so that the main function calls this function"
}
\examples{
\dontrun{
data("timeseries_data_example")
timespan1=timeseries_data_example[,c(1,3,5,7)]
products1=timeseries_data_example[,c(2,4,6,8)]
MM_result <- MM_est(method=TRUE,timespan=timespan1,products=products1,
enz = c(4.4, 4.4, 440, 440), subs=c(4.4, 4.4, 4.4, 4.4), catal = 0.051, 
K_M_init = 1, K_M_m = 1, K_M_v = 100000, std = 10, tun =3.5,
nrepeat = 1000, jump = 10, burn = 1000, volume = FALSE, 
t_unit = "sec", c_unit = "mM")
}
}
