test_that("ELIC function runs and returns the correct structure", {

  # 1. 准备一个非常小、可预测的输入数据集
  # No need for library() calls here, testthat handles the environment.
  set.seed(42) # for reproducibility
  X_test <- matrix(rnorm(20 * 3), ncol = 3)
  beta_test <- c(1, 2, 3)
  e_test <- rnorm(20)
  Y_test <- X_test %*% beta_test + e_test

  # 2. 调用你的 ELIC 函数
  # We expect this function to run without errors
  expect_no_error({
    result <- ELIC(X = X_test, Y = Y_test, K = 2) # Using K=2 for a quick test
  })

  # 3. 检查函数返回的结果是否符合预期

  # 检查返回的是不是一个列表
  expect_true(is.list(result))

  # 检查列表是否包含了所有预期的元素名称
  expected_names <- c("MUopt", "Bopt", "MAEMUopt", "MSEMUopt", "opt", "Yopt")
  expect_named(result, expected_names)

  # 检查Bopt（系数）的维度是否正确 (应该是一个3x1的矩阵)
  expect_equal(dim(result$Bopt), c(3, 1))

})
