% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSELM.R
\name{predict_elm}
\alias{predict_elm}
\title{Prediction function for the ELM model generated with the elm_training() function}
\usage{
predict_elm(model, test)
}
\arguments{
\item{model}{the output of the elm_training() function}

\item{test}{dataset used to perform the testing of the model, the first column must be the column to be fitted for the regression or the labels for the classification}
}
\value{
returns the accuracy on the testset
}
\description{
Prediction function for the ELM model generated with the elm_training() function
}
\examples{
x = runif(100, 0, 50)
y = sqrt(x)
train = data.frame(y,x)
train = data.frame(preProcess(train))
model = OSelm_train.formula(y~x, train, "regression", 100, "hardlim", 10, 10)
#' x = runif(100, 0, 50)
y = sqrt(x)
test = data.frame(y,x)
test = data.frame(preProcess(train))
accuracy = predict_elm(model, test)
}
\references{
[1] N.-Y. Liang, G.-B. Huang, P. Saratchandran, and N. Sundararajan, "A Fast and Accurate On-line Sequential Learning Algorithm for Feedforward Networks" IEEE Transactions on Neural Networks, vol. 17, no. 6, pp. 1411-1423, 2006
}

