% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{get_power_spectra}
\alias{get_power_spectra}
\title{Compute Power Spectra With Optional Subject-Level Aggregation}
\usage{
get_power_spectra(data, by.postn = FALSE, spectrum.args = list())
}
\arguments{
\item{data}{A data frame with reaction time data. Must contain
\code{subjects} and \code{rt}, and for posterior predictive data
optionally \code{postn} and \code{trials}.}

\item{by.postn}{Logical. If \code{TRUE}, compute a separate spectrum
for each posterior predictive draw and each posterior sample index.}

\item{spectrum.args}{A named list of arguments passed directly to
\code{\link{spectrum}}. These override the defaults internally used
in this function. Useful for customizing smoothing spans, detrending,
tapering, and so on.
Defaults: \code{list(spans=c(3, 5), detrend=FALSE, demean=TRUE, log=FALSE, taper=0)}.
By default, we run \code{spectrum} without \code{log}, and log-transform while plotting}
}
\value{
Either a data frame with columns \code{freq} and \code{power}, or (if
\code{by.postn = TRUE}) a list with frequency vector and a matrix of
spectra across posterior samples.
}
\description{
Computes power spectral density estimates using \code{\link{spectrum}},
optionally aggregated across subjects or posterior predictive samples.
All arguments intended for the underlying spectral estimator should be
supplied through \code{spectrum.args}.
}
\details{
The function organizes the data by subject (and optionally posterior
sample index), computes spectra individually, interpolates spectra to
a common frequency grid if needed, and averages them appropriately.
}
