% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{plot.emc}
\alias{plot.emc}
\title{Plot Function for emc Objects}
\usage{
\method{plot}{emc}(
  x,
  stage = "sample",
  selection = c("mu", "sigma2", "alpha"),
  layout = NA,
  ...
)
}
\arguments{
\item{x}{An object of class \code{emc}}

\item{stage}{A character string indicating the sampling stage to be summarized.
Can be \code{preburn}, \code{burn}, \code{adapt}, or \code{sample}.}

\item{selection}{A character vector indicating the parameter group(s).
Defaults to \code{mu}, \code{sigma2}, and \code{alpha}.}

\item{layout}{A vector indicating which layout to use as in par(mfrow = layout). If NA, will automatically generate an appropriate layout.}

\item{...}{Optional arguments that can be passed to \code{get_pars} or \code{plot.default} (see \code{par()})}
}
\value{
A trace/acf plot of the selected MCMC chains
}
\description{
Makes trace plots for model parameters.
}
\details{
If an emc object that has not been run with \code{fit} yet is supplied
prior plots will be returned.
}
\examples{
plot(samples_LNR)
# Or trace autocorrelation for the second subject:
plot(samples_LNR, subject = 2, selection = "alpha")

# Can also plot the trace of for example the group-level correlation:
plot(samples_LNR, selection = "correlation", col = c("green", "purple", "orange"), lwd = 2)
}
