% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_Metropolis.R
\name{draw_Metropolis_single}
\alias{draw_Metropolis_single}
\title{Draw Metropolis single}
\usage{
draw_Metropolis_single(
  theta,
  first.partition,
  nodes,
  effects,
  objects,
  burnin,
  thining,
  num.steps,
  neighborhood = c(0.7, 0.3, 0),
  numgroups.allowed = NULL,
  numgroups.simulated = NULL,
  sizes.allowed = NULL,
  sizes.simulated = NULL,
  return.all.partitions = FALSE
)
}
\arguments{
\item{theta}{model parameters}

\item{first.partition, }{starting partition for the Markov chain}

\item{nodes}{nodeset (data frame)}

\item{effects}{effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{burnin}{integer for the number of burn-in steps before sampling}

\item{thining}{integer for the number of thining steps between sampling}

\item{num.steps}{number of samples}

\item{neighborhood}{= c(0.7,0.3,0), way of choosing partitions: probability vector (2 actors swap, merge/division, single actor move, single pair move, 2 pairs swap, 2 groups reshuffle)}

\item{numgroups.allowed}{= NULL, # vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{= NULL, # vector containing the number of groups simulated}

\item{sizes.allowed}{= NULL,  vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{= NULL, vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{return.all.partitions}{= FALSE option to return the sampled partitions on top of their statistics (for GOF)}
}
\value{
A list
}
\description{
Function to sample the model with a Markov chain (single partition procedure).
}
\examples{
# define an arbitrary set of n = 6 nodes with attributes, and an arbitrary covariate matrix
n <- 6 
nodes <- data.frame(label = c("A","B","C","D","E","F"),
                    gender = c(1,1,2,1,2,2),
                    age = c(20,22,25,30,30,31)) 
friendship <- matrix(c(0, 1, 1, 1, 0, 0,
                       1, 0, 0, 0, 1, 0,
                       1, 0, 0, 0, 1, 0,
                       1, 0, 0, 0, 0, 0,
                       0, 1, 1, 0, 0, 1,
                       0, 0, 0, 0, 1, 0), 6, 6, TRUE)

# choose the effects to be included (see manual for all effect names)
effects <- list(names = c("num_groups","same","diff","tie"),
objects = c("partition","gender","age","friendship"))
objects <- list()
objects[[1]] <- list(name = "friendship", object = friendship)

# set parameter values for each of these effects
parameters <- c(-0.2, 0.2, -0.1, 0.5)

\donttest{
# generate simulated sample, by setting the desired additional parameters for the 
# Metropolis sampler and choosing a starting point for the chain (first.partition)
nsteps <- 100
sample <- draw_Metropolis_single(theta = parameters, 
                                 first.partition = c(1,1,2,2,3,3), 
                                 nodes = nodes, 
                                 effects = effects, 
                                 objects = objects, 
                                 burnin = 100, 
                                 thining = 10, 
                                 num.steps = nsteps, 
                                 neighborhood = c(0,1,0), 
                                 numgroups.allowed = 1:n,
                                 numgroups.simulated = 1:n,
                                 sizes.allowed = 1:n,
                                 sizes.simulated = 1:n,
                                 return.all.partitions = TRUE)


# or: simulate an estimated model
partition <- c(1,1,2,2,2,3) # the partition already defined for the (previous) estimation
nsimulations <- 1000
simulations <- draw_Metropolis_single(theta = estimation$results$est, 
                                      first.partition = partition, 
                                      nodes = nodes, 
                                      effects = effects, 
                                      objects = objects, 
                                      burnin = 100, 
                                      thining = 20, 
                                      num.steps = nsimulations, 
                                      neighborhood = c(0,1,0), 
                                      sizes.allowed = 1:n,
                                      sizes.simulated = 1:n,
                                      return.all.partitions = TRUE)
}

}
