% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectionClass.R
\docType{class}
\name{Selection-class}
\alias{Selection-class}
\title{\code{Selection} class}
\description{
Class used to generate objects that manage the selection in the simulations.
}
\details{
An object of type \code{Selection} is an object which describes the set of
fitnesses which will be taken into account in the simulations. The
selection according to these fitnesses can be applied at three levels:
at the level of the individual, at the level of the production of
gametes and at the level of the gametes themselves.
Selection is therefore genotypic in the first two cases (each genotype
is associated with a fitness value) and haplotypic in the third (each
haplotype is associated with a fitness value).
}
\section{Slots}{

\describe{
\item{\code{genome}}{a \code{Genome} object}

\item{\code{IDhaplotypes}}{IDs of haplotypes}

\item{\code{IDgenotypes}}{IDs of genotypes}

\item{\code{IDgenome}}{ID of the associated genome}

\item{\code{nbHaplo}}{the number of haplotypes}

\item{\code{nbGeno}}{the number of genotypes}

\item{\code{gamFit}}{the list of gametes' fitness}

\item{\code{indFit}}{the list of individuals' fitness}

\item{\code{gamProdFit}}{the list of gamete production fitness}

\item{\code{sOnInds}}{a logical indicating whether a selection on individuals
has been configured by the user}

\item{\code{sOnGams}}{a logical indicating whether a selection on gametes
has been configured by the user}

\item{\code{sOnGamsProd}}{a logical indicating whether a selection on gamete
production has been configured by the user}
}}

\author{
Ehouarn Le Faou
}
