% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ease_recombination.r
\name{ease_recombination}
\alias{ease_recombination}
\title{Compute the ease of recombination of a given technological class}
\usage{
ease_recombination(mat, sparse = FALSE, list = FALSE)
}
\arguments{
\item{mat}{A bipartite adjacency matrix (can be a sparse matrix)}

\item{sparse}{Logical; is the input matrix a sparse matrix? Defaults to FALSE, but can be set to TRUE if the input matrix is a sparse matrix}

\item{list}{Logical; is the input a list? Defaults to FALSE, but can be set to TRUE if the input matrix is a list}
}
\value{
A data frame with two columns: "tech" representing the technological class and "eor" representing the ease of recombination of the technological class
}
\description{
This function computes the ease of recombination of a given technological class from technological classes - patents (incidence) matrices
}
\examples{
## generate a technology - patent matrix
set.seed(31)
mat <- matrix(sample(0:1, 30, replace = TRUE), ncol = 5)
rownames(mat) <- c("T1", "T2", "T3", "T4", "T5", "T6")
colnames(mat) <- c("US1", "US2", "US3", "US4", "US5")

## generate a technology - patent sparse matrix
library(Matrix)
smat <- Matrix(mat, sparse = TRUE)

## run the function
ease_recombination(mat)
ease_recombination(smat, sparse = TRUE)

## generate a regular data frame (list)
my_list <- get_list(mat)

## run the function
ease_recombination(my_list, list = TRUE)
}
\references{
Fleming, L. and Sorenson, O. (2001) Technology as a complex adaptive system: evidence from patent data, \emph{Research Policy} \strong{30}: 1019-1039
}
\seealso{
\code{\link{modular_complexity}}, \code{\link{tci}}, \code{\link{mort}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{complexity}
