% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_list.r
\name{get_list}
\alias{get_list}
\title{Create regular data frames from regions - industries matrices}
\usage{
get_list(mat)
}
\arguments{
\item{mat}{An incidence matrix with regions in rows and industries in columns (or the other way around)}
}
\value{
A data frame with three columns: "Region" (representing the region), "Industry" (representing the industry), and "Count" (representing the count of occurrences)
}
\description{
This function creates regular data frames with three columns (regions, industries, count) from (incidence) matrices (wide to long format) using the reshape2 package
}
\examples{
## generate a region - industry matrix
set.seed(31)
mat <- matrix(sample(0:100, 20, replace = TRUE), ncol = 4)
rownames(mat) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c("I1", "I2", "I3", "I4")

## run the function
get_list(mat)
}
\seealso{
\code{\link{get_matrix}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{data.management}
