% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locational_gini.r
\name{locational_gini}
\alias{locational_gini}
\title{Compute the locational Gini coefficient from regions - industries matrices}
\usage{
locational_gini(mat)
}
\arguments{
\item{mat}{An incidence matrix with regions in rows and industries in columns}
}
\value{
A data frame with two columns: "Industry" and "Loc_gini". The "Industry" column contains the names of the industries, and the "Loc_gini" column contains the locational Gini coefficient computed for each industry from the regions - industries matrix.
}
\description{
This function computes the locational Gini coefficient as proposed by Krugman from regions - industries matrices. The higher the coefficient (theoretical limit = 0.5), the greater the industrial concentration. The locational Gini of an industry that is not localized at all (perfectly spread out) in proportion to overall employment would be 0.
}
\examples{
## generate a region - industry matrix
mat <- matrix(
  c(
    100, 0, 0, 0, 0,
    0, 15, 5, 70, 10,
    0, 20, 10, 20, 50,
    0, 25, 30, 5, 40,
    0, 40, 55, 5, 0
  ),
  ncol = 5, byrow = TRUE
)
rownames(mat) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c("I1", "I2", "I3", "I4", "I5")

## run the function
locational_gini(mat)
}
\references{
Krugman P. (1991) \emph{Geography and Trade}, MIT Press, Cambridge (chapter 2 - p.56)
}
\seealso{
\code{\link{hoover_gini}}, \code{\link{locational_gini_curve}}, \code{\link{hoover_curve}}, \code{\link{lorenz_curve}}, \code{\link{gini}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{concentration}
\keyword{inequality}
