% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readELS.R
\name{readELS}
\alias{readELS}
\title{Connect to Education Longitudinal Study (ELS:2002) Data}
\usage{
readELS(
  path = getwd(),
  filename = "els_02_12_byf3pststu_v1_0.sav",
  wgtFilename = ifelse(filename == "els_02_12_byf3pststu_v1_0.sav",
    "els_02_12_byf3stubrr_v1_0.sav", NA),
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{a character value to the directory path of the extracted set of
data files and layout files.}

\item{filename}{a character value of the name of the SPSS (.sav) data file
in the specified \code{path} to be read.}

\item{wgtFilename}{a character value of the name of the associated balanced
repeated replication (BRR) weight SPSS (.sav) data file
in the specified \code{path} to be read. This argument
is applicable only for the student-level data, which
contains a separate data file containing the weight
replicate information. If using default filenames
(recommended), then you shouldn't need to specify
this parameter because it will inspect the \code{filename}
argument. For data files with no BRR weight file
associated, specify a value of \code{NULL} or \code{NA}.}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read
function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output
while the \code{readELS} function is running to indicate
processing progress.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for the ELS longitudinal dataset
}
\description{
Opens a connection to an ELS data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the ELS longitudinal dataset(s)
to an \code{edsurvey.data.frame}.  The ELS 2002 study consisted of
four distinct separate datasets that cannot be combined:
\itemize{
  \item{Student: bas -year through follow-up three (default)}
  \item{School: base year through follow-up one}
  \item{Institution: follow-up two}
  \item{Institution: follow-up three}
}
}
\examples{
\dontrun{
# read-in student file including weight file as default
els_df <- readELS("~/ELS/2002") #student level with weights)
d <- getData(data=els_df, varnames=c("stu_id", "bysex", "bystlang"))
summary(d)



# read-in with parameters specified (student level with weights)
els_wgt_df <- readELS(path = "~/ELS/2002", 
                      filename = "els_02_12_byf3pststu_v1_0.sav", 
                      wgtFilename = "els_02_12_byf3stubrr_v1_0.sav",
                      verbose = TRUE, 
                      forceReread = FALSE)

# read-in with parameters specified (school level, no separate weight replicate file)
els_sch_df <- readELS(path = "~/ELS/2002", 
                      filename = "els_02_12_byf1sch_v1_0.sav", 
                      wgtFilename = NA,
                      verbose = TRUE, 
                      forceReread = FALSE)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, \code{\link{getData}}, and \code{\link{downloadECLS_K}}
}
\author{
Tom Fink
}
