% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff.ini.maxeig.general.R
\name{eff.ini.maxeig.general}
\alias{eff.ini.maxeig.general}
\title{General matrix maximal eigenpair}
\usage{
eff.ini.maxeig.general(A, v0_tilde = NULL, z0 = NULL, z0numeric, xi = 1,
  digit.thresh = 6)
}
\arguments{
\item{A}{The input general matrix.}

\item{v0_tilde}{The unnormalized initial vector \eqn{\tilde{v0}}.}

\item{z0}{The type of initial \eqn{z_0} used to calculate the approximation of \eqn{\rho(Q)}.
There are three types: 'fixed', 'Auto' and 'numeric' corresponding to three choices
of \eqn{z_0} in paper.}

\item{z0numeric}{The numerical value assigned to initial \eqn{z_0} as an approximation of
\eqn{\rho(Q)} when z_0='numeric'.}

\item{xi}{The coefficient used to form the convex combination of \eqn{\delta_1^{-1}} and
\eqn{(v_0,-Q*v_0)_\mu}, it should between 0 and 1.}

\item{digit.thresh}{The precise level of output results.}
}
\value{
A list of eigenpair object are returned, with components \eqn{z}, \eqn{v} and \eqn{iter}.
\item{z}{The approximating sequence of the maximal eigenvalue.}
\item{v}{The approximating eigenfunction of the corresponding eigenvector.}
\item{iter}{The number of iterations.}
}
\description{
Calculate the maximal eigenpair for the general matrix.
}
\examples{
A = matrix(c(1, 1, 3, 2, 2, 2, 3, 1, 1), 3, 3)
eff.ini.maxeig.general(A, v0_tilde = rep(1, dim(A)[1]), z0 = 'fixed')

A = matrix(c(1, 1, 3, 2, 2, 2, 3, 1, 1), 3, 3)
eff.ini.maxeig.general(A, v0_tilde = rep(1, dim(A)[1]), z0 = 'Auto')

##Symmetrizing A converge to second largest eigenvalue
A = matrix(c(1, 3, 9, 5, 2, 14, 10, 6, 0, 11, 11, 7, 0, 0, 1, 8), 4, 4)
S = (t(A) + A)/2
N = dim(S)[1]
a = diag(S[-1, -N])
b = diag(S[-N, -1])
c = rep(NA, N)
c[1] = -diag(S)[1] - b[1]
c[2:(N - 1)] = -diag(S)[2:(N - 1)] - b[2:(N - 1)] - a[1:(N - 2)]
c[N] = -diag(S)[N] - a[N - 1]

z0ini = eff.ini.maxeig.tri(a, b, c, xi = 7/8)$z[1]
eff.ini.maxeig.general(A, v0_tilde = rep(1, dim(A)[1]), z0 = 'numeric',
z0numeric = 28 - z0ini)
}
\seealso{
\code{\link{eff.ini.maxeig.tri}} for the tridiagonal matrix maximal 
eigenpair by rayleigh quotient iteration algorithm.
\code{\link{eff.ini.maxeig.shift.inv.tri}} for the tridiagonal matrix 
maximal eigenpair by shifted inverse iteration algorithm.
}
