% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_deltak.R
\name{find_deltak}
\alias{find_deltak}
\title{Compute \eqn{\delta_k}}
\usage{
find_deltak(Q, v)
}
\arguments{
\item{Q}{The given tridiagonal matrix.}

\item{v}{The column vector on the right hand of equation.}
}
\value{
A list of \eqn{\delta_k} for given vector \eqn{v} and matrix \eqn{Q}.
}
\description{
Compute \eqn{\delta_k} for given vector \eqn{v} and matrix \eqn{Q}.
}
\examples{
a = c(1:7)^2
b = c(1:7)^2
c = rep(0, length(a) + 1)
c[length(a) + 1] = 8^2
N = length(a)
Q = tridiag(b, a, -c(b[1] + c[1], a[1:N - 1] + b[2:N] + c[2:N], a[N] + c[N + 1]))
find_deltak(Q, v=rep(1,dim(Q)[1]))
}
