% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri.sol.R
\name{tri.sol}
\alias{tri.sol}
\title{Solve the linear equation (-Q-zI)w=v.}
\usage{
tri.sol(Q, z, v)
}
\arguments{
\item{Q}{The given tridiagonal matrix.}

\item{z}{The Rayleigh shift.}

\item{v}{The column vector on the right hand of  equation.}
}
\value{
A solution sequence \eqn{w} to the equation (-Q-zI)w=v.
}
\description{
Construct the solution of linear equation (-Q-zI)w=v.
}
\examples{
a = c(1:7)^2
b = c(1:7)^2
c = rep(0, length(a) + 1)
c[length(a) + 1] = 8^2
N = length(a)
zstart = 6
Q = tridiag(b, a, -c(b[1] + c[1], a[1:N - 1] + b[2:N] + c[2:N], a[N] + c[N + 1]))
tri.sol(Q, z=zstart, v=rep(1,dim(Q)[1]))
}
