% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_analysis.R
\name{estimate_sde_iterative}
\alias{estimate_sde_iterative}
\title{Iterative GLS Estimation for SDEs}
\usage{
estimate_sde_iterative(
  target,
  predictors,
  data,
  initial_drift = NULL,
  max_iter = 10,
  tol = 1e-04
)
}
\arguments{
\item{target}{Numeric vector of target values (derivatives)}

\item{predictors}{Data frame of predictor variables}

\item{data}{Full data frame}

\item{initial_drift}{Initial drift equation (optional)}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Convergence tolerance (RMSE change in coefficients)}
}
\value{
An sde_model object with refined estimates
}
\description{
Refines drift and diffusion estimates using iterative Generalized Least
Squares, which is more appropriate when heteroscedasticity is substantial.
}
