% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_AovSum.R
\name{trainer_AovSum}
\alias{trainer_AovSum}
\title{Trainer: Interpret ANOVA (AovSum) with an LLM-ready prompt}
\usage{
trainer_AovSum(
  aovsum_obj,
  introduction = NULL,
  alpha = 0.05,
  t_test = NULL,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{aovsum_obj}{An object whose printed output contains sections named
"Ftest" and "Ttest" (e.g., \code{FactoMineR::AovSum()}).}

\item{introduction}{Optional character context paragraph for the analysis.
Defaults to a generic description.}

\item{alpha}{Numeric significance level used as an instruction for the LLM.
Default 0.05.}

\item{t_test}{Optional character vector to filter the T-test section by
factor names and/or interactions (e.g. "Factor A" or "Factor A:Factor B").}

\item{audience}{Target audience, one of c("beginner","applied","advanced").}

\item{summary_only}{Logical; if TRUE, return a compact 3-bullet executive summary.}

\item{llm_model}{Character model name for the generator (e.g., "llama3").}

\item{generate}{Logical; if TRUE, calls trainer_core_generate_or_return().}
}
\value{
Character prompt (if generate = FALSE) or a list.
}
\description{
Builds an English-only, audience-tailored prompt to interpret an ANOVA
produced by FactoMineR::AovSum. The function never invents numbers:
it only passes verbatim excerpts to the LLM and instructs how to interpret
deviations (sum-to-zero coding) as performance drivers.
}
\examples{
\dontrun{
# Example 1: SensoMineR chocolates (requires SensoMineR)
if (requireNamespace("SensoMineR", quietly = TRUE)) {
# Load data from SensoMineR
data("chocolates", package = "SensoMineR")
# ANOVA summary with Product and Panelist
res <- FactoMineR::AovSum(Granular ~ Product * Panelist, data = sensochoc)

intro <- "Six chocolates have been evaluated by a sensory panel,
during two days, according to a sensory attribute: granular.
The panel has been trained according to this attribute
and panellists should be reproducible when rating this attribute."
intro <- gsub("\n", " ", intro)
intro <- gsub("\\\\s+", " ", intro)
cat(intro)

prompt <- trainer_AovSum(res, audience = "beginner",
                 t_test = c("Product", "Panelist"),
                 introduction = intro)
cat(prompt)

res <- gemini_generate(prompt, compile_to = "html")
}

# Example 2: Poussin dataset (shipped with this package)
data(poussin)
intro <- "For incubation, 45 chicken eggs were randomly assigned to three batches of 15.
Three treatments (different incubation temperatures) were then applied to the batches.
We assume that after hatching, all chicks were raised under identical conditions
and then weighed at a standard reference age.
At that time, the sex of the chicks - a factor known beforehand to cause
significant weight differences - could also be observed.
The objective is to choose the treatment that maximizes chick weight."
intro <- gsub("\n", " ", intro)
intro <- gsub("\\\\s+", " ", intro)
cat(intro)

res <- FactoMineR::AovSum(Weight ~ Gender * Temperature, data = poussin)

prompt <- trainer_AovSum(res,
                 audience = "beginner",
                 t_test = c("Gender", "Temperature"),
                 introduction = intro)
cat(prompt)

res <- gemini_generate(prompt, compile_to = "html")
}

}
