% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_LinearModel.R
\name{trainer_LinearModel}
\alias{trainer_LinearModel}
\title{Trainer: Interpret FactoMineR::LinearModel with an LLM-ready prompt}
\usage{
trainer_LinearModel(
  lm_obj,
  introduction = NULL,
  alpha = 0.05,
  t_test = NULL,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{lm_obj}{An object returned by FactoMineR::LinearModel(...).}

\item{introduction}{Optional character string giving the study context.}

\item{alpha}{Numeric significance level (default 0.05).}

\item{t_test}{Optional character vector to filter the T-test section by
factor names and/or interactions (e.g. "FactorA" or "FactorA:FactorB").}

\item{audience}{One of c("beginner","applied","advanced").}

\item{summary_only}{Logical; if TRUE, return a 3-bullet executive summary.}

\item{llm_model}{Character model name for the generator (e.g., "llama3").}

\item{generate}{Logical; if TRUE, call the generator.}
}
\value{
Character prompt or list.
}
\description{
Builds an English-only, audience-tailored prompt to interpret a
FactoMineR::LinearModel result. Handles model selection (AIC/BIC) and
instructs how to interpret deviation contrasts (sum-to-zero) for factors.
Works for ANOVA, ANCOVA, and multiple regression.
}
\examples{
# --- Example 1: multiple regression with selection (ham) -------------------
data(ham)
if (requireNamespace("FactoMineR", quietly = TRUE)) {
  intro_ham <- "A sensory analysis institute wants to know if it's possible to predict
  the overall liking of a ham from its sensory description.
  A trained panel used the following attributes to describe 21 hams:
  Juiciness, Crispy, Tenderness, Pasty, Fibrous, Salty, Sweet, Meaty,
  Seasoned, Metallic, Ammoniated, Fatty, Braised, Lactic.
  Afterward, an Overall Liking score was assigned to each of the hams."
  # collapse whitespace safely without extra packages
  intro_ham <- gsub("\n", " ", intro_ham)
  intro_ham <- gsub("\\\\s+", " ", intro_ham)

  res <- FactoMineR::LinearModel(`Overall liking` ~ ., data = ham, selection = "bic")
  pr  <- trainer_LinearModel(res, introduction = intro_ham, audience = "advanced",
                             generate = FALSE)
  cat(pr)
}

# --- Example 2: interaction with a categorical factor (deforestation) ------
data(deforestation)
if (requireNamespace("FactoMineR", quietly = TRUE)) {
  intro_flume <- "The study's goal is to determine how river deforestation affects
  the relationship between water and air temperature.
  The dataset contains maximum air and water temperatures measured over
  28 ten-day periods before deforestation and 28 periods after deforestation.
  The main objective is to understand if and how the link between air and
  water temperature changes after deforestation."
  intro_flume <- gsub("\n", " ", intro_flume)
  intro_flume <- gsub("\\\\s+", " ", intro_flume)

  res <- FactoMineR::LinearModel(Temp_water ~ Temp_air * Deforestation,
                                 data = deforestation, selection = "none")
  pr  <- trainer_LinearModel(res, introduction = intro_flume, audience = "advanced",
                             generate = FALSE)
  cat(pr)
}

}
