% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataprep.R
\name{fastaconc}
\alias{fastaconc}
\title{Concatenate Fasta Files in a Single Multispecies Fasta File}
\usage{
fastaconc(otus, inputdir = ".", out.file = "./concatenated_multispecies.fasta")
}
\arguments{
\item{otus}{a character vector giving the otus' names.}

\item{inputdir}{path to the directory containing the individual fasta files.}

\item{out.file}{path and name of output file.}
}
\value{
A single multispecies fasta file with the sequences of each species spliced in a single sequence.
}
\description{
Concatenate fasta files from different species in a single multispecies fasta file.
}
\details{
When we have fasta files (extension should be '.fasta'), each one for a species containing different sequences of the given species, this function concatenate the different sequences of the same species and writes it as a single sequence in a single multispecies fasta file. If the individual fasta files are found in the working directory, the inputdir argument don't need to be passed. The names of the individual fasta files must match the otus' names.
}
\examples{
\dontrun{fastaconc(otus = c('Glis_glis', 'Ovis_aries', 'Sus_scrofa'))}
}
\seealso{
df2fasta()
}
