% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRTauLeap.R
\name{SIRTauLeap}
\alias{SIRTauLeap}
\title{SIR model with tau leap method (P 6.5).}
\usage{
SIRTauLeap(pars, init, end.time)
}
\arguments{
\item{pars}{\code{\link{vector}} with 5 values: the transmission, recovery and death rates, the population size assumed to be constant and the time step. The names of these values must be "beta", "gamma", "mu", "N" and "tau" respectively.}

\item{init}{\code{\link{vector}} with 3 values: the initial number of susceptibles, infectious and recovered, respectively. The names of these values must be "X", "Y" and "Z" respectively.}

\item{end.time}{end time to be simulated.}
}
\value{
\code{\link{list}}. The first three elements are the vectors \code{*$pars}, \code{*$init} and \code{*$time}, containing the \code{pars}, \code{init} and \code{end.time} arguments of the function. The fourth element \code{*$results} is a \code{\link{data.frame}} with up to as many rows as time steps determined by the parameters \code{tau} and \code{end.time}. The first column contains the time steps. The second, third and fourth columns contain the number of susceptibles, infectious and recovered.
}
\description{
SIR model with demographic stochasticity approximated using the tau-leap method and assuming Poisson distributions.
}
\details{
This is the R version of program 6.5 from page 204 of "Modeling Infectious Disease in humans and animals" by Keeling & Rohani.
}
\examples{
# Parameters and initial conditions.
parameters <- c(beta = 1, gamma = 1 / 10, mu = 5e-4, N = 50, tau = 1)
initials <- c(X = 5, Y = 1, Z = 44)
end.time <- 2 * 365

# Solve and plot.
sir.demog.stoch <- SIRTauLeap(pars = parameters, init = initials,
                              end.time = end.time)
PlotMods(sir.demog.stoch)

}
\references{
Keeling, Matt J., and Pejman Rohani. Modeling infectious diseases in humans and animals. Princeton University Press, 2008.
}
