% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.record.R
\name{record_attr_history}
\alias{record_attr_history}
\title{Record Attribute History}
\usage{
record_attr_history(dat, at, attribute, posit_ids, values)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}

\item{at}{The time where the recording happens.}

\item{attribute}{The name of the value to record.}

\item{posit_ids}{A numeric vector of posit_ids to which the measure applies.
(see \code{get_posit_ids}).}

\item{values}{The values to be recorded.}
}
\value{
The updated \code{netsim_dat} main list object.
}
\description{
This function records values specific to a time-step and a group of nodes.
In the records, the \code{posit_ids} are converted to \code{unique_ids} which
allows the recording of data for nodes that are no longer in the network by
the end of the run. The records are stored in \code{dat[["attr.history"]]}
where \code{dat} is the main \code{netsim_dat} class object, and can be
accessed from the \code{netsim} object with \code{get_attr_history}.
}
\details{
See the "Time-Varying Parameters" section of the "Working With Model
Parameters" vignette.
}
\examples{
\dontrun{
# This function must be used inside a custom module
dat <- record_attr_history(dat, at, "attr_1", get_posit_ids(dat), 5)
some_nodes <- get_posit_ids(dat)
some_nodes <- some_nodes[runif(length(some_nodes)) < 0.2]
dat <- record_attr_history(
  dat, at,
  "attr_2",
  some_nodes,
  rnorm(length(some_nodes))
)
}

}
