% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_samples}
\alias{get_samples}
\alias{get_samples.estimate_infections}
\alias{get_samples.epinow}
\alias{get_samples.forecast_infections}
\alias{get_samples.estimate_secondary}
\alias{get_samples.forecast_secondary}
\alias{get_samples.estimate_truncation}
\title{Get posterior samples from a fitted model}
\usage{
get_samples(object, ...)

\method{get_samples}{estimate_infections}(object, ...)

\method{get_samples}{epinow}(object, ...)

\method{get_samples}{forecast_infections}(object, ...)

\method{get_samples}{estimate_secondary}(object, ...)

\method{get_samples}{forecast_secondary}(object, ...)

\method{get_samples}{estimate_truncation}(object, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., from \code{estimate_infections()})}

\item{...}{Additional arguments (currently unused)}
}
\value{
A \code{data.table} with columns: date, variable, strat, sample, time,
value, type. Contains all posterior samples for all parameters.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Extracts posterior samples from a fitted model, combining all parameters
into a single data.table with dates and metadata.
}
\examples{
\dontrun{
# After fitting a model
samples <- get_samples(fit)
# Filter to specific parameters
R_samples <- samples[variable == "R"]
}
}
