% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_secondary.R
\name{simulate_secondary}
\alias{simulate_secondary}
\title{Simulate secondary observations from primary observations}
\usage{
simulate_secondary(
  primary,
  day_of_week_effect = NULL,
  secondary = secondary_opts(),
  delays = delay_opts(),
  truncation = trunc_opts(),
  obs = obs_opts(),
  CrIs = c(0.2, 0.5, 0.9),
  backend = "rstan"
)
}
\arguments{
\item{primary}{a data frame of primary reports (column \code{primary}) by date
(column \code{date}). Column \code{primary} must be numeric and \code{date} must be in
date format.}

\item{day_of_week_effect}{either \code{NULL} (no day of the week effect) or a
numerical vector of length specified in \code{\link[=obs_opts]{obs_opts()}} as \code{week_length}
(default: 7) if \code{week_effect} is set to TRUE. Each element of the vector
gives the weight given to reporting on this day (normalised to 1).
The default is \code{NULL}.}

\item{secondary}{A call to \code{\link[=secondary_opts]{secondary_opts()}} or a list containing the
following  binary variables: cumulative, historic, primary_hist_additive,
current, primary_current_additive. These parameters control the structure of
the secondary model, see \code{\link[=secondary_opts]{secondary_opts()}} for details.}

\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{truncation}{A call to \code{\link[=trunc_opts]{trunc_opts()}} defining the truncation of
the observed data. Defaults to \code{\link[=trunc_opts]{trunc_opts()}}, i.e. no truncation.  See the
\code{\link[=estimate_truncation]{estimate_truncation()}} help file for an approach to estimating this from
data where the \code{dist} list element returned by \code{\link[=estimate_truncation]{estimate_truncation()}} is
used as the \code{truncation} argument here, thereby propagating the uncertainty
in the estimate.}

\item{obs}{A list of options as generated by \code{\link[=obs_opts]{obs_opts()}} defining the
observation model. Defaults to \code{\link[=obs_opts]{obs_opts()}}.}

\item{CrIs}{Deprecated; specify credible intervals when using \code{\link[=summary]{summary()}} or
\code{\link[=plot]{plot()}}}

\item{backend}{Character string indicating the backend to use for fitting
stan models. Supported arguments are "rstan" (default) or "cmdstanr".}
}
\value{
A data.table of simulated secondary observations (column \code{secondary})
by date.
}
\description{
Simulations are done from a given trajectory of primary observations by
applying any given delays and observation parameters.
}
\details{
In order to simulate, all parameters that are specified such as the mean and
standard deviation of delays or observation scaling, must be fixed.
Uncertain parameters are not allowed.

A function of the same name that was previously based on a reimplementation
of that model in R with potentially time-varying scalings and delays is
available as `convolve_and_scale()
}
\examples{
\donttest{
## load data.table to manipulate `example_confirmed` below
library(data.table)
cases <- as.data.table(example_confirmed)[, primary := confirm]
sim <- simulate_secondary(
  cases,
  delays = delay_opts(fix_parameters(example_reporting_delay)),
  obs = obs_opts(family = "poisson")
)
}
}
