% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clinical_data}
\alias{clinical_data}
\title{Clinical Trials Data for Epidemiological Analysis}
\format{
A data frame with 200 rows and 6 columns:
\describe{
  \item{trial_id}{Character, unique identifier for each trial participant.}
  \item{arm}{Character, treatment arm (e.g., Treatment, Control).}
  \item{outcome}{Numeric, binary outcome (0 = no response, 1 = response).}
  \item{age}{Numeric, patient age (years).}
  \item{health_score}{Numeric, baseline health score (0 to 100).}
  \item{dose}{Numeric, treatment dose level (e.g., 0 for control, 1 for low dose, 2 for high dose).}
}
}
\source{
Simulated data for demonstration purposes.
}
\usage{
clinical_data
}
\description{
A dataset containing simulated clinical trial data for analyzing treatment outcomes, suitable for power calculations, logistic regression, Random Forest, and SVM.
}
\examples{
data("clinical_data")
clinical_data$outcome <- as.factor(clinical_data$outcome)
epi_model(clinical_data, formula = outcome ~ age + health_score + dose, type = "logistic")
epi_model(clinical_data, formula = outcome ~ age + health_score + dose, type = "rf")
epi_visualize(clinical_data, x = "arm", y = "outcome", type = "boxplot")
}
\keyword{datasets}
