% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\name{sim_check}
\alias{sim_check}
\title{Checking input for the sim_paneldata function}
\usage{
sim_check(N, tt, beta, p, gamma, eta, lambda, het, phi, sd, burnins)
}
\arguments{
\item{N}{The number of cross-sectional units in the panel-data}

\item{tt}{The number of time periods in the panel-data}

\item{beta}{The vector of coefficients for the placebo variables. Must be of size tt.}

\item{p}{The number of additional regressors}

\item{gamma}{The vector of coefficients for the additional regressors}

\item{eta}{The vector of fixed effects. Must be of size N.}

\item{lambda}{The vector of time effects. Must be of size tt.}

\item{het}{The heteroskedasticity parameter. Must be 0 or 1: \code{het = 1} indicates that the error terms are generated under heteroskedasticity, \code{het = 0} indicates the error terms are generated under homoscedasticity.}

\item{phi}{The AR(1) parameter for the error terms. Must be in the interval [0,1).}

\item{sd}{The standard deviation of the error terms. Must be a positive number.}

\item{burnins}{The number of burn-ins for the AR(1) process. Must be a positive integer.}
}
\value{
A list with two elements: a logical object error indicating if an error is encountered and a message (a character string) corresponding to the error. If error is TRUE, message contains an error message. If error is FALSE, message is an empty string.
}
\description{
Checking input for the sim_paneldata function
}
