% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEnrollment.R
\name{predictEnrollment}
\alias{predictEnrollment}
\title{Predict enrollment}
\usage{
predictEnrollment(
  df = NULL,
  target_n,
  enroll_fit,
  lags = 1,
  pilevel = 0.9,
  nyears = 4,
  nreps = 500,
  by_treatment = FALSE,
  ngroups = 1,
  alloc = NULL,
  treatment_label = NULL,
  seed.num = NULL
)
}
\arguments{
\item{df}{The subject-level enrollment data, including \code{trialsdt},
\code{randdt} and \code{cutoffdt}. The data should also include
\code{treatment} coded as 1, 2, and so on, and
\code{treatment_description} for prediction
by treatment group. By default, it is set to \code{NULL}
for enrollment prediction at the design stage.}

\item{target_n}{The target number of subjects to enroll in the study.}

\item{enroll_fit}{The pre-fitted enrollment model used to
generate predictions.}

\item{lags}{The day lags to compute the average enrollment rate to
carry forward for the B-spline enrollment model. By default,
it is set to 1.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nyears}{The number of years after the data cut for prediction.
By default, it is set to 4.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}

\item{by_treatment}{A Boolean variable to control whether or not to
predict enrollment by treatment group. By default,
it is set to \code{FALSE}.}

\item{ngroups}{The number of treatment groups for enrollment prediction
at the design stage. By default, it is set to 1.
It is replaced with the actual number of
treatment groups in the observed data if \code{df} is not \code{NULL}.}

\item{alloc}{The treatment allocation in a randomization block.
By default, it is set to \code{NULL}, which yields equal allocation
among the treatment groups.}

\item{treatment_label}{The treatment labels for treatments in a
randomization block for design stage prediction.}

\item{seed.num}{The number of the random seed. The default is NULL.}
}
\value{
A list of prediction results, which includes important information
such as the median, lower and upper percentiles for the estimated
time to reach the target number of subjects, as well as simulated
enrollment data for new subjects. The data for the
prediction plot is also included within the list.
}
\description{
Utilizes a pre-fitted enrollment model to generate
enrollment times for new subjects and provide a prediction
interval for the expected time to reach the enrollment target.
}
\details{
The \code{enroll_fit} variable can be used for enrollment prediction
at the design stage. A piecewise uniform can be parameterized
through the time intervals, \code{accrualTime}, which is
treated as fixed, and the enrollment rates in the intervals,
\code{accrualrate}, the number of patients in each intervals.
A piecewise Poisson model can be parameterized
through the time intervals, \code{accrualTime}, which is
treated as fixed, and the enrollment rates in the intervals,
\code{accrualIntensity}, the log of which is used as the
model parameter. For the homogeneous Poisson, time-decay,
and piecewise Poisson models, \code{enroll_fit} is used to
specify the prior distribution of model parameters, with
a very small variance being used to fix the parameter values.
It should be noted that the B-spline model is not appropriate
for use during the design stage.

During the enrollment stage, \code{enroll_fit} is the enrollment model
fit based on the observed data. The fitted enrollment model is used to
generate enrollment times for new subjects.
}
\examples{
# Enrollment prediction at the design stage
fit1 <- list(model = "piecewise uniform",
             theta = -0.58, 
             vtheta=0, accrualTime =0)
                  
 predictEnrollment(df = NULL, target_n=200, enroll_fit = fit1,lags=46,
                                  pilevel=0.9, nyears=4, nreps=100,by_treatment=TRUE,
                                  ngroups=2, alloc=c(1,1), treatment_label=c('a','b'))

}
\references{
Xiaoxi Zhang and Qi Long. Stochastic modeling and prediction for
accrual in clinical trials. Stat in Med. 2010; 29:649-658.
}
