% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tte.R
\name{tte}
\alias{tte}
\title{Calculating log-rank test p-value, median time from each arm, hazard ratio between two arms, number of subjects and events in time-to-event outcomes.}
\usage{
tte(os, osc, grp, type, test = "Futility")
}
\arguments{
\item{os}{Time to event variable}

\item{osc}{Time to event censoring variable}

\item{grp}{Treatment assignment indicator with 1 denoting the treated group, and 0 denoting the placebo group.}

\item{type}{either "all" or "logrank" or "hr"}

\item{test}{a character denotes the test type, include "Superiority","Futility","Two-sided"}
}
\value{
If type='all', return a list that includes the log-rank p-value, median time from each arm, hazard ratio between arms,
and 95\% confidence interval of hazard ratio, number of subjects and events; and events
If type='logrank', return a list that includes the log-rank p-value, number of subjects and events;
If type='hr', return a list that includes hazard ratio between arms, and 95\% confidence interval of hazard ratio
}
\description{
Calculate log-rank test p-value, median time from each arm, HR between arms, number of subjects and events
}
\details{
The control arm
}
\examples{
n <- 500
event <- runif(n,1, 5)
osc<-1*(event<=4)
os <- pmin(event,4)
trt<-c(rep(0,n/2),rep(1,n/2))
tte(os,osc,trt,type='all')

}
