/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.data;

public class SccsData {
    public int[] y;
    public double[] a;
    public double[][] x;
    public int[] stratumId;
    public double[] time;

    public SccsData(int[] y, double[] a, double[][] x, int[] stratumId, double[] time) {
        if (y.length < 2) {
            throw new IllegalArgumentException("SCCS data must have at least two rows");
        }
        if (y.length != time.length || y.length != x.length || y.length != a.length || y.length != stratumId.length) {
            throw new IllegalArgumentException("All dimensions must be equal");
        }
        int i = 1;
        while (i < stratumId.length) {
            if (stratumId[i - 1] > stratumId[i]) {
                throw new IllegalArgumentException("SCCS data must be sorted by stratumId");
            }
            ++i;
        }
        this.y = y;
        this.a = a;
        this.x = x;
        this.stratumId = stratumId;
        this.time = time;
    }
}

