% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplementaryCols.R
\name{supplementaryCols}
\alias{supplementaryCols}
\title{Supplementary columns}
\usage{
supplementaryCols(SUP.DATA, res, center = TRUE, scale = TRUE)
}
\arguments{
\item{SUP.DATA}{a data matrix of supplementary measures (must have the same
observations [rows] as active data)}

\item{res}{ExPosition or TExPosition results}

\item{center}{a boolean, string, or numeric. See \code{\link{expo.scale}}}

\item{scale}{a boolean, string, or numeric. See \code{\link{expo.scale}}}
}
\value{
A list of values containing:\cr \item{fjj}{factor scores computed
for supplemental columns} \item{djj}{squared distances for supplemental
columns} \item{rjj}{cosines for supplemental columns}
}
\description{
Computes factor scores for supplementary measures (columns).
}
\details{
This function recognizes the class types of: \code{\link{epPCA}},
\code{\link{epMDS}}, \code{\link{epCA}}, \code{\link{epMCA}}, and
\code{TExPosition} methods. Further, the function recognizes if Hellinger
(as opposed to row profiles; in CA, MCA and DICA) were used.
}
\author{
Derek Beaton
}
\keyword{misc}
\keyword{multivariate}
