% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_npoint.R
\name{recombination_npoint}
\alias{recombination_npoint}
\title{n-point recombination for DE}
\usage{
recombination_npoint(X, M, recpars = list(N = NULL))
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/npoint" (n-point) recombination for the ExpDE (as used in 
the Simple GA).
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_npoint()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{N} : cut number points for crossover.\cr
   Accepts integer value \code{0 <= N < n}, where \code{n} is the 
   dimension of the problem; Use \code{N = 0} or \code{N = NULL} for randomly 
   choosing a number of cut points.\cr
   Defaults to \code{NULL}.
}
}

\section{References}{

L.J. Eshelman, R.A. Caruana, J.D. Schaffer (1989), "Biases in the crossover 
landscape. In: Proceedings of the Third International Conference on Genetic 
Algorithms, pp. 10-19, San Francisco, CA, USA.
}

