% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpEXP.R
\name{VennPlot}
\alias{VennPlot}
\title{Make a three-set Venn Diagram}
\usage{
VennPlot(
  P1_RPM,
  P2_RPM,
  F1_RPM,
  P1_name,
  P2_name,
  F1_name,
  type,
  homoeologs,
  rpm_threshold = 1
)
}
\arguments{
\item{P1_RPM}{A data frame. The RPM table of genes in P1 species. For the RPM table, the first column is the gene identifier, and other columns are the RPM values of the genes in each biological replicate.}

\item{P2_RPM}{A data frame. The RPM table of genes in P2 species.}

\item{F1_RPM}{A data frame. The RPM table of genes in F1 species.}

\item{P1_name}{Character. Category names of P1 species.}

\item{P2_name}{Character. Category names of P2 species.}

\item{F1_name}{Character. Category names of F1 species.}

\item{type}{Character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes in the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{rpm_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 1 (the average RPM of all replicates).}
}
\value{
Venn diagram.
}
\description{
This function creates a Venn Diagram to display the overlap of expressed genes between three sets (parents and progeny).
}
\details{
The 'homoeologs' table contains the orthologs pairs. In detail, the first column is the group name (unique) of homoeologs among three species (Parents: P1; P2, Progeny: F1), the second column is the Gene ID of P1, the third column is the Gene ID of P2. And the fourth column and fifth columns are the identifier of F1 orthologs derived from P1 and P2 ancestors, respectively (e.g. "Homoeolog1	BraA01t00004Z	BolC01g000040.2J BnA01g0000030.1 BnC01g0424620.1").
}
\examples{
#miRNA
VennPlot(P1_RPM = P1_miRNA_rpm,
         P2_RPM = P2_miRNA_rpm,
         F1_RPM = F1_miRNA_rpm,
         P1_name = "B.napus(AACC)",
         P2_name = "B.rapa(AA)",
         F1_name = "B.napus x B.rapa(AAAACC)",type="sRNA")
}
