% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProfileDataFrame.R
\name{ProfileDataFrame}
\alias{ProfileDataFrame}
\title{Profile a data frame}
\usage{
ProfileDataFrame(DF, dgts = 3, charMax = 20)
}
\arguments{
\item{DF}{data frame to be characterized}

\item{dgts}{digits retained for numerical characterizations like fractions (default = 3)}

\item{charMax}{maximum number of characters retained in representing the most frequent value for a variable (default = 20)}
}
\value{
data frame with one row for each column of \code{DF} and these columns:
\itemize{
\item Variable the name of the column from \code{DF} being characterized
\item Type the class of \code{Variable} (e.g., numeric, integer, character, etc.)
\item nMiss the number of missing (NA) or blank \code{Variable} records
\item fracMiss the fraction of total records represented by \code{nMiss}
\item nLevels the number of distinct values \code{Variable} exhibits
\item topValue the most frequently occurring \code{Variable} value, truncated to \code{charMax} characters
\item topChars the actual number of characters required to represent \code{topValue}
\item topFreq the number of times \code{topValue} occurs
\item topFrac the fraction of total records represented by \code{topFreq}
\item Homog the Shannon homogeneity measure for \code{Variable}
}
}
\description{
Given the data frame \code{DF}, create a new data frame with one row for
each column of \code{DF} that characterizes that column in terms of the
number and fraction of missing values, the most frequent value and
its frequency and other characteristics like the Shannon homogeneity
measure computed by the \code{\link[=ShannonHomogeneity]{ShannonHomogeneity()}} function.
}
\examples{
ProfileDataFrame(ChickWeight)
}
