% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShannonHomogeneity.R
\name{ShannonHomogeneity}
\alias{ShannonHomogeneity}
\title{Compute the Shannon homogeneity for a vector}
\usage{
ShannonHomogeneity(x, dgts = 3)
}
\arguments{
\item{x}{the vector to be characterized}

\item{dgts}{number of digits in the return value (default = 3)}
}
\value{
a numerical homogeneity measure between 0 and 1
}
\description{
Computes the Shannon homogeneity (normalized Shannon entropy) for
a vector, typically categorical but the procedure also works with
numerical vectors.  Returns a value in the range from 0 (for a highly
inhomogeneous vector, concentrated entirely on one of L > 1 levels)
to 1 (for a completely homogeneous vector).  By convention, vectors
of length 0 or 1 return homogeneity values of 1.
}
\examples{
x <- rep(c("a", "b", "c", "d", "e"), 200)
y <- c(rep("a", 497), rep("b", 497), rep("c", 2), rep("d", 2), rep("e", 2))
z <- c(rep("a", 996), "b", "c", "d", "e")
ShannonHomogeneity(x)
ShannonHomogeneity(y)
ShannonHomogeneity(z)

}
