% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizeOutliers.R
\name{SummarizeOutliers}
\alias{SummarizeOutliers}
\title{Summarize outliers detected by three methods}
\usage{
SummarizeOutliers(x, label = NULL, labelName = NULL, thresh = c(3, 3, 1.5))
}
\arguments{
\item{x}{numerical vector in which outliers are to be detected}

\item{label}{optional identifying tag for outliers (default NULL gives
an index into the elements of \code{x} declared outliers)}

\item{labelName}{optional name for the \code{label} column, if specified
(default NULL labels this column as Case)}

\item{thresh}{vector of threshold values for each outlier detection rule (default = c(3, 3, 1.5))}
}
\value{
Data frame with one row for each outlier detected by any of the
three methods and these 5 columns:
\itemize{
\item Record (or \code{labelName}) giving the location or label for each outlier
\item Value the value detected as an outlier by at least one method
\item ThreeSigma 1 if the outlier is detected by the three-sigma rule, 0 otherwise
\item Hampel 1 if the outlier is detected by the Hampel identifier, 0 otherwise
\item Boxplot 1 if the outlier is detected by the boxplot rule, 0 otherwise
}

Note that this data frame is empty (0 rows) if no outliers are detected by any method
}
\description{
Generates a summary of outliers detected by the three-sigma edit rule,
the Hampel identifier, and the boxplot rule, including an optional
label to identify the outlying points
}
\examples{
x <- seq(-1, 1, length = 100)
x[1:10] <- 10
SummarizeOutliers(x)
}
