% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fars_methods.R
\name{logLik.fars}
\alias{logLik.fars}
\title{Log-Likelihoods for \code{fars} Object}
\usage{
\method{logLik}{fars}(object, tau, ...)
}
\arguments{
\item{object}{An object of class \code{fars}.}

\item{tau}{Numeric. Quantile level to select (e.g. 0.50).}

\item{...}{Additional arguments (ignored).}
}
\value{
An object of class \code{"logLik"}, as returned by the
underlying quantile regression model.
}
\description{
Returns the log-likelihood for a single quantile regression
stored in a \code{fars} object (selected via \code{tau}).
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100),
                            factors = matrix(rnorm(100 * 3), ncol = 3))
logLik(fars_result, tau = 0.50)

}
